<?php
include 'template/koneksi.php';
include 'template/header.php';
include 'template/menu.php';
?>

<div class="container mt-4">
    <h3 class="text-center">Data Absensi</h3>
    <form id="filterForm">
        <div class="row">
            <!-- Input Tanggal Mulai -->
            <div class="col-md-3">
                <div class="form-group">
                    <label for="start_date">Tanggal Mulai</label>
                    <input type="date" id="start_date" name="start_date" class="form-control" required>
                </div>
            </div>
            <!-- Input Tanggal Selesai -->
            <div class="col-md-3">
                <div class="form-group">
                    <label for="end_date">Tanggal Selesai</label>
                    <input type="date" id="end_date" name="end_date" class="form-control" required>
                </div>
            </div>
            <!-- Dropdown Jenis -->
            <div class="col-md-3">
                <div class="form-group">
                    <label for="jenis">Jenis</label>
                    <select id="jenis" name="jenis" class="form-select">
                        <option value="">Semua</option>
                        <option value="Masuk">Masuk</option>
                        <option value="Pulang">Pulang</option>
                        <option value="izin">Izin</option>
                    </select>
                </div>
            </div>
            <!-- Dropdown Status -->
            <div class="col-md-3">
                <div class="form-group">
                    <label for="status">Status</label>
                    <select id="status" name="status" class="form-select">
                        <option value="">Semua</option>
                        <option value="hadir">Hadir</option>
                        <option value="terlambat">Terlambat</option>
                        <option value="bolos">Bolos</option>
                        <option value="pulang">Pulang</option>
                        <option value="izin">Izin</option>
                        <option value="sakit">Sakit</option>
                        <option value="tidak masuk">Tidak Masuk</option>
                        <option value="tidak pulang">Tidak Pulang</option>
                    </select>
                </div>
            </div>
        </div>
        <div class="mt-3">
            <button type="button" id="filterButton" class="btn btn-primary">Tampilkan</button>
        </div>
    </form>

    <!-- Area untuk Menampilkan Data -->
    <div class="table-responsive mt-4" id="resultTable">
        <!-- Data akan dimuat di sini secara asinchronous -->
    </div>

    <script>
        // Event Listener untuk Tombol Print
        document.getElementById('printButton').addEventListener('click', function() {
            const printContent = document.getElementById('resultTable').innerHTML; // Ambil isi tabel
            const originalContent = document.body.innerHTML; // Simpan isi asli halaman

            // Siapkan halaman untuk cetak
            document.body.innerHTML = `
                <html>
                <head>
                    <title>Cetak Data Absensi</title>
                    <style>
                        table { width: 100%; border-collapse: collapse; margin: 20px 0; }
                        th, td { border: 1px solid #000; padding: 8px; text-align: left; }
                        th { background-color: #f2f2f2; }
                    </style>
                </head>
                <body>
                    <h3>Data Absensi</h3>
                    ${printContent}
                </body>
                </html>
            `;

            window.print(); // Cetak halaman

            // Kembalikan isi halaman asli
            document.body.innerHTML = originalContent;
            location.reload(); // Refresh halaman untuk memuat ulang event handler
        });
    </script>
</div>
<script src="https://cdn.jsdelivr.net/npm/xlsx/dist/xlsx.full.min.js"></script>
<script>
    // Event Listener untuk Tombol Tampilkan
    document.getElementById('filterButton').addEventListener('click', function() {
        // Ambil Data dari Form
        const start_date = document.getElementById('start_date').value;
        const end_date = document.getElementById('end_date').value;
        const jenis = document.getElementById('jenis').value;
        const status = document.getElementById('status').value;

        // Validasi Tanggal
        if (!start_date || !end_date) {
            alert('Tanggal mulai dan tanggal selesai harus diisi.');
            return; // Berhenti jika validasi gagal
        }

        // Lakukan Request AJAX
        const xhr = new XMLHttpRequest();
        xhr.open('POST', 'proses_absensi.php', true);
        xhr.setRequestHeader('Content-type', 'application/x-www-form-urlencoded');
        xhr.onload = function() {
            if (this.status === 200) {
                // Tampilkan Hasil di Area resultTable
                document.getElementById('resultTable').innerHTML = this.responseText;
            }
        };
        xhr.send(`start_date=${start_date}&end_date=${end_date}&jenis=${jenis}&status=${status}`);
    });

    // Event Listener untuk Tombol Export Excel
    document.getElementById('exportExcelButton').addEventListener('click', function () {
        // Ambil tabel dari halaman
        const table = document.getElementById('resultTable');

        // Konversi tabel HTML menjadi worksheet
        const wb = XLSX.utils.table_to_book(table, { sheet: "Absensi" });

        // Simpan sebagai file Excel
        XLSX.writeFile(wb, `Absensi_${new Date().toISOString().slice(0, 10)}.xlsx`);
    });

</script>

<?php
include 'template/footer.php';
?>
