<?php
include 'template/koneksi.php';
include 'template/header.php';
include 'template/menu.php';

// Query untuk mengambil data absensi hari ini
$sql_absensi = "
    SELECT 
        a.rfid, 
        s.nama_siswa, 
        a.jenis, 
        a.status, 
        a.keterangan,
        TIME(a.date_time) AS jam_absensi
    FROM tbl_absensi a
    LEFT JOIN tbl_siswa s ON a.rfid = s.rfid
    WHERE DATE(a.date_time) = CURDATE()
    ORDER BY a.date_time DESC
";
$result_absensi = $conn->query($sql_absensi);

?>

<div class="container mt-4">
    <h3>Data Absensi Hari Ini</h3>
    <div class="table-responsive mt-3">
        <table class="table table-bordered table-striped" id="absensiTable">
            <thead>
                <tr>
                    <th>No</th>
                    <th>RFID</th>
                    <th>Nama</th>
                    <th>Jenis</th>
                    <th>Status</th>
                    <th>Keterangan</th>
                    <th>Jam</th>
                </tr>
            </thead>
            <tbody>
                <?php
                $nomor = 1;
                if ($result_absensi->num_rows > 0) {
                    while ($row = $result_absensi->fetch_assoc()) {
                        echo "<tr>";
                        echo "<td>" . $nomor++ . "</td>";
                        echo "<td>" . htmlspecialchars($row['rfid']) . "</td>";
                        echo "<td>" . htmlspecialchars($row['nama_siswa']) . "</td>";
                        echo "<td>" . htmlspecialchars($row['jenis']) . "</td>";
                        echo "<td>" . htmlspecialchars($row['status']) . "</td>";
                        echo "<td>" . htmlspecialchars($row['keterangan']) . "</td>";
                        echo "<td>" . htmlspecialchars($row['jam_absensi']) . "</td>";
                        echo "</tr>";
                    }
                } else {
                    echo "<tr><td colspan='7' class='text-center'>Tidak ada data absensi hari ini</td></tr>";
                }
                ?>
            </tbody>
        </table>
    </div>
</div>

<?php
include 'template/footer.php';
?>
