<?php
include 'template/koneksi.php';

// Ambil ID kelas dari parameter URL
$id_kelas = isset($_GET['id_kelas']) ? intval($_GET['id_kelas']) : 0;

// Jika ID kelas tidak valid, redirect kembali ke halaman kelas.php
if ($id_kelas <= 0) {
    header("Location: kelas.php");
    exit();
}

// Query untuk mengambil data kelas berdasarkan ID
$sql = "SELECT * FROM tbl_kelas WHERE id_kelas = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $id_kelas);
$stmt->execute();
$result = $stmt->get_result();
$kelas = $result->fetch_assoc();

// Jika data kelas tidak ditemukan, redirect kembali ke halaman kelas.php
if (!$kelas) {
    header("Location: kelas.php");
    exit();
}

// Tutup statement
$stmt->close();

// Proses update data kelas jika form disubmit
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $kelas_number = $_POST['kelas'];
    $nama_kelas = $_POST['nama_kelas'];

    // Query untuk mengupdate data kelas
    $sql_update = "UPDATE tbl_kelas SET kelas = ?, nama_kelas = ? WHERE id_kelas = ?";
    $stmt_update = $conn->prepare($sql_update);
    $stmt_update->bind_param("isi", $kelas_number, $nama_kelas, $id_kelas);

    if ($stmt_update->execute()) {
        // Jika update berhasil, redirect kembali ke halaman kelas.php dengan pesan sukses
        header("Location: kelas.php?status=update_success");
        exit();
    } else {
        $error_message = "Gagal mengupdate data kelas!";
    }

    // Tutup statement update
    $stmt_update->close();
}

include 'template/header.php';
include 'template/menu.php';
?>

<?php if (isset($error_message)) : ?>
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <?php echo $error_message; ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
<?php endif; ?>

<!-- Form Edit Kelas -->
<div class="container mt-5">
    <h2>Edit Kelas</h2>
    <form class="form form-vertical" method="POST" action="edit_kelas.php?id_kelas=<?php echo $id_kelas; ?>">
        <div class="form-body">
            <div class="row">
                <div class="col-12">
                    <div class="form-group">
                        <label for="kelas">Kelas</label>
                        <input type="number" class="form-control" name="kelas" value="<?php echo htmlspecialchars($kelas['kelas']); ?>" required>
                    </div>
                </div>
                <div class="col-12">
                    <div class="form-group">
                        <label for="nama_kelas">Nama Kelas</label>
                        <input type="text" class="form-control" name="nama_kelas" value="<?php echo htmlspecialchars($kelas['nama_kelas']); ?>" required>
                    </div>
                </div>
                <div class="col-12 d-flex justify-content-end">
                    <button type="submit" class="btn btn-primary me-1 mb-1">Update</button>
                    <a href="kelas.php" class="btn btn-light-secondary me-1 mb-1">Batal</a>
                </div>
            </div>
        </div>
    </form>
</div>

<?php
include 'template/footer.php';
?>
