<?php
// Include file koneksi database
include 'template/koneksi.php';

// Proses saat form dikirim
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Ambil data dari form
    $rfid = $_POST['rfid'];
    $jenis = 'izin';
    $status = $_POST['status'];
    $keterangan = $_POST['keterangan'];
    $dateTime = date('Y-m-d H:i:s'); // Tanggal dan jam saat ini

    // Query untuk memasukkan data ke tabel tbl_absensi
    $query = "INSERT INTO tbl_absensi (date_time, rfid, jenis, status, keterangan)
              VALUES (?, ?, ?, ?, ?)";
    $stmt = $conn->prepare($query);
    $stmt->bind_param('sssss', $dateTime, $rfid, $jenis, $status, $keterangan);

    // Eksekusi query dan cek keberhasilannya
    if ($stmt->execute()) {
        $successMessage = "Pengajuan berhasil disimpan!";
    } else {
        $errorMessage = "Terjadi kesalahan: " . $stmt->error;
    }

    // Tutup statement
    $stmt->close();
}

include 'template/header.php';
include 'template/menu.php';
?>


<div class="container mt-5">
    <h2 class="mb-4">Pengajuan Izin / Tidak Hadir</h2>

    <!-- Tampilkan pesan jika ada -->
    <?php if (!empty($successMessage)) : ?>
        <div class="alert alert-success"><?php echo $successMessage; ?></div>
    <?php elseif (!empty($errorMessage)) : ?>
        <div class="alert alert-danger"><?php echo $errorMessage; ?></div>
    <?php endif; ?>

    <form action="" method="POST">
        <!-- Input Keterangan -->
        <div class="mb-3">
            <label for="keterangan" class="form-label">Keterangan</label>
            <textarea name="keterangan" id="keterangan" class="form-control" rows="4" placeholder="Tulis keterangan" required></textarea>
        </div>

        <!-- Dropdown Status -->
        <div class="mb-3">
            <label for="status" class="form-label">Status</label>
            <select name="status" id="status" class="form-select" required>
                <option value="" disabled selected>Pilih Status</option>
                <option value="izin">Izin</option>
                <option value="sakit">Sakit</option>
                <option value="sakit">Tanpa Keterangan</option>
            </select>
        </div>

        <!-- Input RFID -->
        <div class="mb-3">
            <label for="rfid" class="form-label">RFID/NIS</label>
            <input type="text" name="rfid" id="rfid" class="form-control" placeholder="Tulis RFID/NIS siswa disini" required>
        </div>

        <!-- Tombol Submit -->
        <button type="submit" class="btn btn-primary">Proses</button>
    </form>
</div>

<?php
include 'template/footer.php';
?>
