<?php
include 'template/koneksi.php';
include 'template/header.php';
include 'template/menu.php';

// Ambil data kelas untuk dropdown
$sql_kelas = "SELECT id_kelas, nama_kelas FROM tbl_kelas ORDER BY nama_kelas ASC";
$result_kelas = $conn->query($sql_kelas);

// Inisialisasi variabel filter
$tanggal_mulai = $_GET['tanggal_mulai'] ?? '';
$tanggal_selesai = $_GET['tanggal_selesai'] ?? '';
$performa = $_GET['performa'] ?? '';
$id_kelas = $_GET['kelas'] ?? '';

// Buat klausa WHERE tambahan untuk filter kelas dan tanggal
$where_kelas = !empty($id_kelas) ? "WHERE s.id_kelas = '$id_kelas'" : "";
$where_tanggal = !empty($tanggal_mulai) && !empty($tanggal_selesai) ?
    "AND DATE(a.date_time) BETWEEN '$tanggal_mulai' AND '$tanggal_selesai'" : "";

// Urutan berdasarkan performa
$order_clause = "";
if ($performa == 'paling_rajin') {
    $order_clause = "ORDER BY jumlah_hadir DESC, jumlah_tidak_masuk ASC";
} elseif ($performa == 'paling_malas') {
    $order_clause = "ORDER BY jumlah_tidak_masuk DESC, jumlah_hadir ASC";
}

// Query utama laporan performa
$sql_performa = "
    SELECT
        s.id_siswa,
        s.nama_siswa,
        k.nama_kelas,
        COUNT(CASE WHEN LOWER(a.status) = 'hadir' THEN 1 END) AS jumlah_hadir,
        COUNT(CASE WHEN LOWER(a.status) = 'terlambat' THEN 1 END) AS jumlah_terlambat,
        COUNT(CASE WHEN LOWER(a.status) IN ('tidak masuk', 'bolos') OR a.status IS NULL THEN 1 END) AS jumlah_tidak_masuk
    FROM tbl_siswa s
    LEFT JOIN tbl_kelas k ON s.id_kelas = k.id_kelas
    LEFT JOIN tbl_absensi a
        ON s.rfid = a.rfid $where_tanggal
    $where_kelas
    GROUP BY s.id_siswa, s.nama_siswa, k.nama_kelas
    $order_clause
";

$result_performa = $conn->query($sql_performa);
?>

<div class="container mt-4">
    <h3 class="mb-3">📊 Laporan Performa Kehadiran Siswa</h3>

    <!-- Form Filter -->
    <form method="GET" action="laporan_performa.php" class="mb-3">
        <div class="row">
            <div class="col-md-3">
                <label for="tanggal_mulai" class="form-label">Tanggal Mulai</label>
                <input type="date" name="tanggal_mulai" id="tanggal_mulai" class="form-control" value="<?= htmlspecialchars($tanggal_mulai) ?>">
            </div>
            <div class="col-md-3">
                <label for="tanggal_selesai" class="form-label">Tanggal Selesai</label>
                <input type="date" name="tanggal_selesai" id="tanggal_selesai" class="form-control" value="<?= htmlspecialchars($tanggal_selesai) ?>">
            </div>
            <div class="col-md-3">
                <label for="performa" class="form-label">Performa</label>
                <select name="performa" id="performa" class="form-select">
                    <option value="">Pilih Performa</option>
                    <option value="paling_rajin" <?= $performa == 'paling_rajin' ? 'selected' : '' ?>>Paling Rajin</option>
                    <option value="paling_malas" <?= $performa == 'paling_malas' ? 'selected' : '' ?>>Paling Malas</option>
                </select>
            </div>
            <div class="col-md-3">
                <label for="kelas" class="form-label">Kelas</label>
                <select name="kelas" id="kelas" class="form-select">
                    <option value="">Pilih Kelas</option>
                    <?php
                    if ($result_kelas->num_rows > 0) {
                        while ($row_kelas = $result_kelas->fetch_assoc()) {
                            $selected = $id_kelas == $row_kelas['id_kelas'] ? 'selected' : '';
                            echo "<option value='" . htmlspecialchars($row_kelas['id_kelas']) . "' $selected>" . htmlspecialchars($row_kelas['nama_kelas']) . "</option>";
                        }
                    }
                    ?>
                </select>
            </div>
        </div>
        <div class="mt-3">
            <button type="submit" class="btn btn-primary">Tampilkan</button>
            <a href="laporan_performa.php" class="btn btn-secondary">Reset</a>
        </div>
    </form>

    <!-- Tabel Performa -->
    <div class="table-responsive mt-4">
        <table class="table table-bordered table-striped text-center">
            <thead class="table-dark">
                <tr>
                    <th>No</th>
                    <th>Nama Siswa</th>
                    <th>Kelas</th>
                    <th>Jumlah Hadir</th>
                    <th>Jumlah Terlambat</th>
                    <th>Jumlah Tidak Masuk</th>
                </tr>
            </thead>
            <tbody>
                <?php
                if ($result_performa && $result_performa->num_rows > 0) {
                    $no = 1;
                    $total_hadir = $total_terlambat = $total_tidak_masuk = 0;

                    while ($row = $result_performa->fetch_assoc()) {
                        // Ubah nilai 0 menjadi "-"
                        $hadir = $row['jumlah_hadir'] == 0 ? '-' : $row['jumlah_hadir'];
                        $terlambat = $row['jumlah_terlambat'] == 0 ? '-' : $row['jumlah_terlambat'];
                        $tidak_masuk = $row['jumlah_tidak_masuk'] == 0 ? '-' : $row['jumlah_tidak_masuk'];

                        $total_hadir += $row['jumlah_hadir'];
                        $total_terlambat += $row['jumlah_terlambat'];
                        $total_tidak_masuk += $row['jumlah_tidak_masuk'];

                        echo "<tr>
                                <td>{$no}</td>
                                <td class='text-start'>" . htmlspecialchars($row['nama_siswa']) . "</td>
                                <td>" . htmlspecialchars($row['nama_kelas']) . "</td>
                                <td>$hadir</td>
                                <td>$terlambat</td>
                                <td>$tidak_masuk</td>
                              </tr>";
                        $no++;
                    }

                    // Baris total keseluruhan
                    echo "<tr class='table-secondary fw-bold'>
                            <td colspan='3'>Total Keseluruhan</td>
                            <td>" . ($total_hadir == 0 ? '-' : $total_hadir) . "</td>
                            <td>" . ($total_terlambat == 0 ? '-' : $total_terlambat) . "</td>
                            <td>" . ($total_tidak_masuk == 0 ? '-' : $total_tidak_masuk) . "</td>
                          </tr>";
                } else {
                    echo "<tr><td colspan='6' class='text-center'>Tidak ada data ditemukan.</td></tr>";
                }
                ?>
            </tbody>
        </table>
    </div>
</div>

<?php include 'template/footer.php'; ?>
