<?php
$host = 'localhost';
$dbname = 'absenpcs'; // Ganti dengan nama database Anda
$username = 'root'; // Ganti dengan username MySQL Anda
$password = ''; // Ganti dengan password MySQL Anda

try {
    date_default_timezone_set('Asia/Jakarta'); // Set timezone ke Jakarta

    $pdo = new PDO("mysql:host=$host;dbname=$dbname", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    $absensi_today = null;
    $error_message = null;
    $success_message = null;
    $siswa_info = null;

    $today = date('Y-m-d');

    // Ambil jam masuk dari tbl_pengaturan
    $tbl_pengaturan = $pdo->prepare("SELECT * FROM tbl_pengaturan LIMIT 1");
    $tbl_pengaturan->execute();
    $data_pengaturan = $tbl_pengaturan->fetch(PDO::FETCH_ASSOC);

    // Ambil jam masuk dari tbl_pengaturan
    $stmt = $pdo->prepare("SELECT jam_masuk FROM tbl_pengaturan LIMIT 1");
    $stmt->execute();
    $pengaturan = $stmt->fetch(PDO::FETCH_ASSOC);
    $jam_masuk = $pengaturan ? $pengaturan['jam_masuk'] : '07:00:00'; // Default jika tidak ada data

    // Ambil data absensi hari ini, termasuk nama kelas
    $stmt = $pdo->prepare("
        SELECT
            tbl_siswa.nama_siswa,
            tbl_siswa.id_kelas,
            tbl_kelas.nama_kelas,
            tbl_absensi.date_time,
            tbl_absensi.jenis,
            tbl_absensi.status
        FROM tbl_absensi
        JOIN tbl_siswa ON tbl_absensi.rfid = tbl_siswa.rfid
        JOIN tbl_kelas ON tbl_siswa.id_kelas = tbl_kelas.id_kelas
        WHERE DATE(tbl_absensi.date_time) = :today AND jenis='masuk'
        ORDER BY tbl_absensi.date_time DESC
    ");
    $stmt->execute(['today' => $today]);
    $absensi_today = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        $rfid_nis = trim($_POST['rfid_nis']);
        $stmt = $pdo->prepare("SELECT * FROM tbl_siswa WHERE rfid = :rfid_nis OR nis = :rfid_nis");
        $stmt->bindValue(':rfid_nis', $rfid_nis, PDO::PARAM_STR);
        $stmt->execute();
        $siswa = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($siswa) {
            $checkStmt = $pdo->prepare("SELECT * FROM tbl_absensi WHERE rfid = :rfid AND jenis = 'masuk' AND DATE(date_time) = :today");
            $checkStmt->execute([ 'rfid' => $siswa['rfid'], 'today' => $today ]);
            $existing_absensi = $checkStmt->fetch(PDO::FETCH_ASSOC);

            if ($existing_absensi) {
                $error_message = "Pengguna telah melakukan absen masuk.";
            } else {
                $date_time = date('Y-m-d H:i:s');
                $current_time = date('H:i:s');
                $jenis = "masuk";
                // ganti jam masuk 13:15:00 dari tbl_pengaturan
                $status = ($current_time > $jam_masuk) ? "terlambat" : "hadir";
                $insertStmt = $pdo->prepare("INSERT INTO tbl_absensi (date_time, rfid, jenis, status)
                                           VALUES (:date_time, :rfid, :jenis, :status)");
                $insertStmt->execute([
                    'date_time' => $date_time,
                    'rfid' => $siswa['rfid'],
                    'jenis' => $jenis,
                    'status' => $status
              ]);

              // 🔎 Cek jumlah absen masuk hari ini
              $countStmt = $pdo->prepare("SELECT COUNT(*) as jumlah
                  FROM tbl_absensi
                  WHERE rfid = :rfid AND jenis = 'masuk' AND DATE(date_time) = :today");
              $countStmt->execute(['rfid' => $siswa['rfid'], 'today' => $today]);
              $count = $countStmt->fetch(PDO::FETCH_ASSOC)['jumlah'];

              if ($count >= 2) {
                  // Jika sudah 2x maka hapus semua absensi masuk hari ini untuk siswa tersebut
                  $deleteStmt = $pdo->prepare("DELETE FROM tbl_absensi
                      WHERE rfid = :rfid AND jenis = 'masuk' AND DATE(date_time) = :today");
                  $deleteStmt->execute(['rfid' => $siswa['rfid'], 'today' => $today]);

                  $error_message = "Absensi $siswa[nama_siswa] dibatalkan karena melakukan absen masuk 2 kali.";
                  $success_message = null;
                  $siswa_info = null;
              } else {
                  $success_message = "Absensi berhasil.";
                  $siswa_info = [
                      'nama' => $siswa['nama_siswa'],
                      'foto' => $siswa['foto_siswa'],
                      'date_time' => $date_time,
                      'status' => $status
                  ];
                  echo "<script>takeSnapshot()</script>";
              }

                // Tampilkan absensi terbaru setelah pengambilan gambar
                $stmt = $pdo->prepare("
                    SELECT
                        tbl_siswa.nama_siswa,
                        tbl_siswa.id_kelas,
                        tbl_kelas.nama_kelas,
                        tbl_absensi.date_time,
                        tbl_absensi.jenis,
                        tbl_absensi.status
                    FROM tbl_absensi
                    JOIN tbl_siswa ON tbl_absensi.rfid = tbl_siswa.rfid
                    JOIN tbl_kelas ON tbl_siswa.id_kelas = tbl_kelas.id_kelas
                    WHERE DATE(tbl_absensi.date_time) = :today AND jenis='masuk'
                    ORDER BY tbl_absensi.date_time DESC
                ");
                $stmt->execute(['today' => $today]);
                $absensi_today = $stmt->fetchAll(PDO::FETCH_ASSOC);
            }
        } else {
            $error_message = "Siswa dengan RFID/NIS '$rfid_nis' tidak ditemukan.";
        }
    }
} catch (PDOException $e) {
    echo 'Koneksi gagal: ' . $e->getMessage();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Absensi Masuk</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <style>
        body {
            background-image: url('foto/smk.jpg');
            background-size: cover;
            background-position: center;
            background-attachment: fixed;
        }
    </style>
</head>
<body>
    <nav class="navbar navbar-expand-lg navbar-dark bg-dark">
        <a class="navbar-brand" href="#">
            <img src="<?= $data_pengaturan['logo_aplikasi']?>" width="30" height="30" alt="">
        </a>
        <a class="navbar-brand" href="#"><?= $data_pengaturan['nama_aplikasi']?></a>
        <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarNavAltMarkup" aria-controls="navbarNavAltMarkup" aria-expanded="false" aria-label="Toggle navigation">
            <span class="navbar-toggler-icon"></span>
        </button>
        <div class="collapse navbar-collapse" id="navbarNavAltMarkup">
            <div class="navbar-nav">
            <a class="nav-item nav-link active" href="masuk.php">ABSEN MASUK</a>
            <a class="nav-item nav-link" href="keluar.php">ABSEN PULANG</a>
            </div>
        </div>
    </nav>
    <div class="container mt-3 text-center">
        <h2 class="mb-1">ABSENSI MASUK</h2>
        <h2 class="mb-4">PESERTA DIDIK SMK YAPAN SUKABUMI</h2>
        <div class="row">
            <div class="col-md-6">
                <form method="POST" action="">
                    <div class="form-group">
                        <img src="tap.png" width="200px"><br>
                        <label for="inputRfidNis">Tempelkan kartu atau ketikkan NIS</label>
                        <input type="text" class="form-control" id="inputRfidNis" name="rfid_nis" required autofocus>
                    </div>
                </form>
            </div>
            <div class="col-md-6 d-flex justify-content-center align-items-center">
                <?php if (isset($error_message)) : ?>
                    <div class="card text-center border-danger" style="width: 15rem;">
                        <?php if (!empty($siswa['foto_siswa'])): ?>
                            <img src="foto/<?= htmlspecialchars($siswa['foto_siswa']); ?>" class="card-img-top rounded-img">
                        <?php else: ?>
                            <img src="foto/default.png" class="card-img-top rounded-img">
                        <?php endif; ?>
                        <div class="card-body">
                            <h5 class="card-title text-danger"><?= htmlspecialchars($siswa['nama_siswa'] ?? 'Siswa Tidak Dikenal'); ?></h5>
                            <p class="card-text"><?= htmlspecialchars($error_message); ?></p>
                            <span class="badge badge-warning p-2">Telah melakukan absensi</span>
                        </div>
                    </div>
                <?php endif; ?>

                <?php if (isset($success_message)) : ?>
                    <div class="card text-center border-success" style="width: 15rem;">
                        <img src="foto/<?= htmlspecialchars($siswa_info['foto']); ?>" id="absen-photo" class="card-img-top rounded-img">
                        <div class="card-body">
                            <h5 class="card-title"><?= htmlspecialchars($siswa_info['nama']); ?></h5>
                            <p class="card-text mb-1"><?= date('d/m/Y H:i:s', strtotime($siswa_info['date_time'])); ?></p>
                            <p class="card-text text-capitalize"><?= htmlspecialchars($siswa_info['status']); ?></p>
                            <span class="badge badge-success p-2">Telah melakukan absensi</span>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>

        <?php if (isset($absensi_today)) : ?>
        <div class="mt-4">
            <h4>Absensi Hari Ini:</h4>
            <table class="table table-bordered">
                <thead>
                    <tr>
                        <th>Nomor</th>
                        <th>Nama Siswa</th>
                        <th>Nama Kelas</th> <!-- Nama Kelas ditambahkan -->
                        <th>Tanggal</th>
                        <th>Jam</th>
                        <th>Jenis</th>
                        <th>Status</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($absensi_today as $index => $absensi) : ?>
                    <tr class="<?= $absensi['status'] == 'terlambat' ? 'status-terlambat' : ''; ?>">
                        <td><?= $index + 1; ?></td>
                        <td><?= htmlspecialchars($absensi['nama_siswa']); ?></td>
                        <td><?= htmlspecialchars($absensi['nama_kelas']); ?></td> <!-- Nama Kelas ditampilkan -->
                        <td><?= date('d/m/Y', strtotime($absensi['date_time'])); ?></td>
                        <td><?= date('H:i:s', strtotime($absensi['date_time'])); ?></td>
                        <td><?= htmlspecialchars($absensi['jenis']); ?></td>
                        <td><?= htmlspecialchars($absensi['status']); ?></td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
        <?php endif; ?>
    </div>
    <!-- 🔹 Tambahkan di atas penutup body -->
    <style>
        #camera-container {
            position: fixed;
            top: 70px;
            right: 10px;
            width: 350px;
            height: 250px;
            border: 2px solid #28a745;
            border-radius: 10px;
            overflow: hidden;
            background: #000;
            z-index: 9999;
            box-shadow: 0 0 10px rgba(0,0,0,0.5);
        }

        #camera-container video {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }

        #camera-status {
            position: absolute;
            bottom: 5px;
            left: 5px;
            background: rgba(0,0,0,0.6);
            color: #0f0;
            padding: 2px 5px;
            font-size: 12px;
            border-radius: 5px;
        }
    </style>

    <div id="camera-container">
        <video id="camera-stream" autoplay muted playsinline></video>
        <div id="camera-status">Camera On</div>
    </div>

    <script>
        // 🔹 Otomatis aktifkan kamera saat halaman dimuat
        document.addEventListener('DOMContentLoaded', async () => {
            const video = document.getElementById('camera-stream');
            try {
                const stream = await navigator.mediaDevices.getUserMedia({ video: true, audio: false });
                video.srcObject = stream;
            } catch (error) {
                console.error("Kamera gagal dinyalakan:", error);
                document.getElementById('camera-status').textContent = "Kamera tidak aktif";
                document.getElementById('camera-status').style.color = "#f00";
            }
        });
    </script>
</body>
</html>
