<?php
// Mulai sesi
session_start();

// Load database connection
$host = 'localhost'; // ganti dengan host database Anda
$user = 'root'; // ganti dengan user database Anda
$pass = ''; // ganti dengan password database Anda
$db = 'absenpcs'; // ganti dengan nama database Anda

// Buat koneksi
$conn = new mysqli($host, $user, $pass, $db);

// Cek koneksi
if ($conn->connect_error) {
    die("Koneksi gagal: " . $conn->connect_error);
}

// Ambil data dari form
$user = $_POST['username'];
$pass = $_POST['password'];

// Query untuk mencari pengguna berdasarkan username
$sql = "SELECT * FROM tbl_user WHERE username = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("s", $user);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    $row = $result->fetch_assoc();
    
    // Verifikasi password
    if (password_verify($pass, $row['password'])) {
        // Ambil IP address pengguna untuk mendeteksi lokasi
        $ip = $_SERVER['REMOTE_ADDR'];

        // Gunakan layanan geolokasi untuk mendapatkan nama kota (contoh: menggunakan API ip-api)
        $location = file_get_contents("http://ip-api.com/json/{$ip}");
        $locationData = json_decode($location, true);
        $city = $locationData['city'] ?? 'Unknown';

        // Ambil User-Agent dari header HTTP
        $userAgent = $_SERVER['HTTP_USER_AGENT'];

        // Tentukan pola untuk mendeteksi browser
        $browser = "Unknown Browser";
        $os = "Unknown OS";

        // Deteksi sistem operasi
        if (preg_match('/Windows NT 10.0/', $userAgent)) {
            $os = "Windows 10";
        } elseif (preg_match('/Windows NT 6.1/', $userAgent)) {
            $os = "Windows 7";
        } elseif (preg_match('/Macintosh/', $userAgent)) {
            $os = "Mac OS";
        } elseif (preg_match('/Linux/', $userAgent)) {
            $os = "Linux";
        }

        // Deteksi browser
        if (preg_match('/Chrome/', $userAgent)) {
            $browser = "Google Chrome";
        } elseif (preg_match('/Firefox/', $userAgent)) {
            $browser = "Mozilla Firefox";
        } elseif (preg_match('/Safari/', $userAgent)) {
            $browser = "Safari";
        } elseif (preg_match('/Edge/', $userAgent)) {
            $browser = "Microsoft Edge";
        }
        
        $device = "{$os}, {$browser}";

        // Simpan log ke tbl_log
        $sql_log = "INSERT INTO tbl_log (user_id, lokasi, device) VALUES (?, ?, ?)";
        $stmt_log = $conn->prepare($sql_log);
        $stmt_log->bind_param("iss", $row['id'], $city, $device);
        $stmt_log->execute();

        // Jika password cocok, buat sesi untuk pengguna
        $_SESSION['username'] = $row['username'];
        $_SESSION['role_id'] = $row['role_id'];
        
        echo "<script>alert('Login berhasil!'); window.location.href = 'dashboard.php';</script>";
    } else {
        // Jika password tidak cocok
        echo "<script>alert('Password salah!'); window.location.href = 'login.php';</script>";
    }
} else {
    // Jika username tidak ditemukan
    echo "<script>alert('Username tidak ditemukan!'); window.location.href = 'login.php';</script>";
}

// Tutup statement dan koneksi
$stmt->close();
$conn->close();
?>
