<?php
include 'template/koneksi.php';

// Fungsi untuk memotong gambar menjadi ukuran persegi
function cropImageToSquare($sourcePath, $destinationPath, $fileExt)
{
    list($width, $height) = getimagesize($sourcePath);
    $minDimension = min($width, $height);
    $x = ($width - $minDimension) / 2;
    $y = ($height - $minDimension) / 2;

    $image = null;
    switch ($fileExt) {
        case 'jpg':
        case 'jpeg':
            $image = imagecreatefromjpeg($sourcePath);
            break;
        case 'png':
            $image = imagecreatefrompng($sourcePath);
            break;
        case 'gif':
            $image = imagecreatefromgif($sourcePath);
            break;
        default:
            return false; // Format file tidak didukung
    }

    if ($image) {
        $squareImage = imagecrop($image, ['x' => $x, 'y' => $y, 'width' => $minDimension, 'height' => $minDimension]);
        if ($squareImage) {
            switch ($fileExt) {
                case 'jpg':
                case 'jpeg':
                    imagejpeg($squareImage, $destinationPath);
                    break;
                case 'png':
                    imagepng($squareImage, $destinationPath);
                    break;
                case 'gif':
                    imagegif($squareImage, $destinationPath);
                    break;
            }
            imagedestroy($squareImage);
        }
        imagedestroy($image);
        return true;
    }
    return false;
}

// Cek apakah form telah disubmit
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Ambil data dari form
    $rfid = $_POST['rfid'];
    $nis = $_POST['nis'];
    $nama_siswa = $_POST['nama_siswa'];
    $id_kelas = $_POST['id_kelas'];
    $telepon_siswa = $_POST['telepon_siswa'];
    $nama_wali = $_POST['nama_wali'];
    $telepon_wali = $_POST['telepon_wali'];
    $foto_siswa = 'default.png'; // Nilai default untuk foto_siswa jika tidak ada gambar diunggah

    // Proses upload file gambar
    if (isset($_FILES['foto']) && $_FILES['foto']['error'] == UPLOAD_ERR_OK) {
        $uploadDir = 'foto/'; // Folder penyimpanan file
        $fileTmp = $_FILES['foto']['tmp_name'];
        $fileName = basename($_FILES['foto']['name']);
        $fileExt = strtolower(pathinfo($fileName, PATHINFO_EXTENSION));
        $allowedExt = ['jpg', 'jpeg', 'png', 'gif'];

        // Validasi ekstensi file
        if (in_array($fileExt, $allowedExt)) {
            // Format nama file: "nama-uniqid-rfid.ext"
            $cleanedName = preg_replace("/[^a-zA-Z0-9]/", "", $nama_siswa); // Bersihkan nama_siswa dari karakter tidak valid
            $newFileName = "{$cleanedName}-" . uniqid() . "-{$rfid}.{$fileExt}";
            $uploadPath = $uploadDir . $newFileName;

            // Pindahkan file ke folder tujuan
            if (move_uploaded_file($fileTmp, $uploadPath)) {
                // Crop gambar menjadi persegi
                $croppedPath = $uploadDir . "cropped-" . $newFileName;
                if (cropImageToSquare($uploadPath, $croppedPath, $fileExt)) {
                    // Hapus file asli jika cropping berhasil dan gunakan file yang telah dicrop
                    unlink($uploadPath);
                    $foto_siswa = "cropped-" . $newFileName;
                } else {
                    echo "Gagal memproses cropping gambar.";
                    exit();
                }
            } else {
                echo "Gagal mengunggah file.";
                exit();
            }
        } else {
            echo "Format file tidak didukung. Gunakan file dengan format jpg, jpeg, png, atau gif.";
            exit();
        }
    }

    // Query untuk memasukkan data ke tabel tbl_siswa
    $sql = "INSERT INTO tbl_siswa (rfid, nis, nama_siswa, id_kelas, telepon_siswa, nama_wali, telepon_wali, foto_siswa) 
            VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("ssssssss", $rfid, $nis, $nama_siswa, $id_kelas, $telepon_siswa, $nama_wali, $telepon_wali, $foto_siswa);

    // Eksekusi query
    if ($stmt->execute()) {
        // Redirect ke halaman lain jika berhasil, misalnya ke daftar siswa
        header("Location: siswa.php?status=success");
    } else {
        // Tampilkan pesan error jika gagal
        echo "Error: " . $stmt->error;
    }

    // Tutup statement dan koneksi
    $stmt->close();
    $conn->close();
} else {
    // Redirect jika halaman diakses tanpa melalui form submission
    header("Location: siswa.php");
    exit();
}
?>
