<?php
include 'template/koneksi.php';

// Query untuk mengambil data pengguna berdasarkan username
$sql = "SELECT * FROM tbl_user WHERE username = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("s", $username);
$stmt->execute();
$result = $stmt->get_result();

$userData = $result->fetch_assoc();
$stmt->close();

include 'template/header.php';
include 'template/menu.php';

// Cek status sukses submit data siswa
if (isset($_GET['status']) && $_GET['status'] == 'success') {
    echo '<div class="alert alert-success alert-dismissible show fade">
            Data siswa berhasil disimpan!!!
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
          </div>';
}

// --- Form Pencarian ---
$search_nama  = isset($_GET['nama']) ? $_GET['nama'] : '';
$search_rfid  = isset($_GET['rfid']) ? $_GET['rfid'] : '';
$search_kelas = isset($_GET['kelas']) ? $_GET['kelas'] : '';

// Query dasar
$sql_siswa = "SELECT tbl_siswa.*, tbl_kelas.nama_kelas
              FROM tbl_siswa
              LEFT JOIN tbl_kelas ON tbl_siswa.id_kelas = tbl_kelas.id_kelas
              WHERE 1=1";

// Tambah filter jika ada pencarian
if (!empty($search_nama)) {
    $sql_siswa .= " AND tbl_siswa.nama_siswa LIKE '%" . $conn->real_escape_string($search_nama) . "%'";
}
if (!empty($search_rfid)) {
    $sql_siswa .= " AND tbl_siswa.rfid LIKE '%" . $conn->real_escape_string($search_rfid) . "%'";
}
if (!empty($search_kelas)) {
    $sql_siswa .= " AND tbl_kelas.nama_kelas LIKE '%" . $conn->real_escape_string($search_kelas) . "%'";
}

$sql_siswa .= " ORDER BY tbl_siswa.id_siswa DESC";
$result_siswa = $conn->query($sql_siswa);
?>

<!-- Tombol Add Siswa -->
<button type="button" class="btn btn-outline-primary block mb-3" data-bs-toggle="modal" data-bs-target="#default">
    Add Siswa
</button>

<!-- Form Pencarian -->
<div class="card mb-3">
    <div class="card-body">
        <form method="GET" action="">
            <div class="row">
                <div class="col-md-3">
                    <input type="text" class="form-control" name="nama" placeholder="Cari Nama Siswa" value="<?php echo htmlspecialchars($search_nama); ?>">
                </div>
                <div class="col-md-3">
                    <input type="text" class="form-control" name="rfid" placeholder="Cari Nomor RFID" value="<?php echo htmlspecialchars($search_rfid); ?>">
                </div>
                <div class="col-md-3">
                    <input type="text" class="form-control" name="kelas" placeholder="Cari Kelas" value="<?php echo htmlspecialchars($search_kelas); ?>">
                </div>
                <div class="col-md-3">
                    <button type="submit" class="btn btn-primary">Cari</button>
                    <a href="siswa.php" class="btn btn-secondary">Reset</a>
                </div>
            </div>
        </form>
    </div>
</div>

<!-- Tabel Data Siswa -->
<div class="table-responsive mt-3">
    <table class="table table-striped" id="siswaTable">
        <thead>
            <tr>
                <th>No</th>
                <th>RFID</th>
                <th>NIS</th>
                <th>Siswa</th>
                <th>Kelas</th>
                <th>Tlp Siswa</th>
                <th>Wali</th>
                <th>Tlp Wali</th>
                <th>Foto</th>
                <th>Aksi</th>
            </tr>
        </thead>
        <tbody>
            <?php
            $nomor = 1;
            if ($result_siswa->num_rows > 0) {
                while($row = $result_siswa->fetch_assoc()) {
                    echo "<tr>";
                    echo "<td>" . $nomor++ . "</td>";
                    echo "<td>" . htmlspecialchars($row['rfid']) . "</td>";
                    echo "<td>" . htmlspecialchars($row['nis']) . "</td>";
                    echo "<td>" . htmlspecialchars($row['nama_siswa']) . "</td>";
                    echo "<td>" . htmlspecialchars($row['nama_kelas']) . "</td>";
                    echo "<td>" . htmlspecialchars($row['telepon_siswa']) . "</td>";
                    echo "<td>" . htmlspecialchars($row['nama_wali']) . "</td>";
                    echo "<td>" . htmlspecialchars($row['telepon_wali']) . "</td>";
                    echo "<td><img src='foto/" . htmlspecialchars($row['foto_siswa']) . "' alt='Foto Siswa' style='width: 50px; height: 50px;'></td>";
                    echo "<td>
                            <a href='edit_siswa.php?id=" . $row['id_siswa'] . "' class='btn btn-sm btn-warning'>Edit</a>
                            <a href='hapus_siswa.php?id=" . $row['id_siswa'] . "' class='btn btn-sm btn-danger' onclick='return confirm(\"Apakah Anda yakin ingin menghapus data ini?\")'>Hapus</a>
                          </td>";
                    echo "</tr>";
                }
            } else {
                echo "<tr><td colspan='10' class='text-center'>Tidak ada data siswa</td></tr>";
            }
            ?>
        </tbody>
    </table>
</div>

<!-- Modal Add Siswa -->
<div class="modal fade text-left" id="default" tabindex="-1" role="dialog" aria-labelledby="myModalLabel1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-scrollable" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="myModalLabel1">Add Siswa</h5>
                <button type="button" class="close rounded-pill" data-bs-dismiss="modal" aria-label="Close">
                    <i data-feather="x"></i>
                </button>
            </div>
            <div class="modal-body">
                <form class="form form-vertical" method="POST" action="proses_siswa.php" enctype="multipart/form-data">
                    <div class="form-body">
                        <div class="row">
                            <div class="col-12">
                                <div class="form-group">
                                    <label for="nis">NIS</label>
                                    <input type="number" class="form-control" name="nis" placeholder="NIS" required>
                                </div>
                            </div>
                            <div class="col-12">
                                <div class="form-group">
                                    <label for="nama_siswa">Nama Siswa</label>
                                    <input type="text" class="form-control" name="nama_siswa" placeholder="Nama Siswa" required>
                                </div>
                            </div>
                            <div class="col-12">
                                <div class="form-group">
                                    <label for="id_kelas">Kelas</label>
                                    <select class="form-select" name="id_kelas" required>
                                        <option value="">Pilih Kelas</option>
                                        <?php
                                        $sql_kelas = "SELECT id_kelas, nama_kelas FROM tbl_kelas ORDER BY nama_kelas ASC";
                                        $result_kelas = $conn->query($sql_kelas);
                                        if ($result_kelas->num_rows > 0) {
                                            while ($row_kelas = $result_kelas->fetch_assoc()) {
                                                echo '<option value="' . htmlspecialchars($row_kelas['id_kelas']) . '">' . htmlspecialchars($row_kelas['nama_kelas']) . '</option>';
                                            }
                                        } else {
                                            echo '<option value="">Tidak ada kelas</option>';
                                        }
                                        ?>
                                    </select>
                                </div>
                            </div>
                            <div class="col-12">
                                <div class="form-group">
                                    <label for="telepon_siswa">Tlp Siswa</label>
                                    <input type="text" class="form-control" name="telepon_siswa" placeholder="Telepon Siswa">
                                </div>
                            </div>
                            <div class="col-12">
                                <div class="form-group">
                                    <label for="nama_wali">Nama Wali</label>
                                    <input type="text" class="form-control" name="nama_wali" placeholder="Nama Wali">
                                </div>
                            </div>
                            <div class="col-12">
                                <div class="form-group">
                                    <label for="telepon_wali">Tlp Wali</label>
                                    <input type="text" class="form-control" name="telepon_wali" placeholder="Telepon Wali">
                                </div>
                            </div>
                            <div class="col-12">
                                <div class="form-group">
                                    <label for="foto">Foto Siswa</label>
                                    <input type="file" class="form-control" name="foto" required>
                                </div>
                            </div>
                            <div class="col-12">
                                <div class="form-group">
                                    <label for="rfid">RFID</label>
                                    <input type="text" class="form-control" name="rfid" placeholder="RFID" required>
                                </div>
                            </div>
                            <div class="col-12 d-flex justify-content-end">
                                <button type="submit" class="btn btn-primary me-1 mb-1">Submit</button>
                                <button type="reset" class="btn btn-light-secondary me-1 mb-1">Reset</button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<?php
include 'template/footer.php';
?>
